﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Numerics;
using System.Text;
using System.Threading.Tasks;

namespace Iterators
{
    class Examples30_31
    {
        // Listing 5-30
        public static IEnumerable<int> ThreeNumbers()
        {
            yield return 1;
            yield return 2;
            yield return 3;
        }

        public static void InvokeSimpleIterator()
        {
            foreach (int i in ThreeNumbers())
            {
                Console.WriteLine(i);
            }
        }

        // Listing 5-31
        public static IEnumerable<BigInteger> Fibonacci()
        {
            BigInteger v1 = 1;
            BigInteger v2 = 1;

            while (true)
            {
                yield return v1;
                var tmp = v2;
                v2 = v1 + v2;
                v1 = tmp;
            }
        }

        public static void InvokeEndlessIterator()
        {
            // Ten kod mógłby działać dowolnie długo, ale ponieważ nie stanowi
            // jedynej metody wykonywanej w ramach tego projektu, zatrzymamy
            // go po wyliczeniu 100 elementów ciągu Fibonacciego.
            int count = 0;
            foreach (BigInteger n in Fibonacci())
            {
                Console.WriteLine(n);
                if (++count == 100) { break; }
            }
        }
    }
}
